% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countries_position.R
\name{countries_position}
\alias{countries_position}
\title{Countries position}
\usage{
countries_position(revealed_comparative_advantage = NULL,
  country1 = "country", product1 = "product", value1 = "value",
  proximity_products = NULL, product21 = "from", product22 = "to",
  value2 = "value", product_complexity_index = NULL,
  product3 = "product", value3 = "value", tbl_output = FALSE)
}
\arguments{
\item{revealed_comparative_advantage}{matrix or tibble/data.frame (e.g. the output of
\code{revealed_comparative_advantage()}).
If the input is a matrix it must be a zero/one matrix with countries in rows and products in columns.
If the input is a tibble/data.frame it must contain at least three columns with countries, products and
values.}

\item{country1}{string to indicate the column that contains exporting countries in revealed_comparative_advantage
(set to "country" by default)}

\item{product1}{string to indicate the column that contains exported products in revealed_comparative_advantage
(set to "product" by default)}

\item{value1}{string to indicate the column that contains traded values in revealed_comparative_advantage
(set to "value" by default)}

\item{proximity_products}{matrix or tibble/data.frame (e.g. the output of
\code{proximity_matrices()}).
If the input is a matrix it must be a numeric matrix with products in both
rows and columns.
If the input is a tibble/data.frame it must contain at least three columns columns with
products (twice) and values.}

\item{product21}{string to indicate the first column that contains exported products in proximity_products
(set to "from" by default)}

\item{product22}{string to indicate the second column that contains exported products in proximity_products
(set to "to" by default)}

\item{value2}{string to indicate the column that contains proximity values in proximity_products
(set to "value" by default)}

\item{product_complexity_index}{numeric vector or tibble/data.frame \code{complexity_measures()}).
If the input is a vector it must be numeric with optional names.
If the input is a tibble/data.frame it must contain at least two columns columns with products and values.}

\item{product3}{string to indicate the column that contains exported products in proximity_products (e.g. "product")}

\item{value3}{string to indicate the column that contains proximity values in proximity_products (e.g. "value")
from \code{complexity_measures()})}

\item{tbl_output}{logical value to use tibble output instead of a matrix output (set to FALSE by default)}
}
\description{
Countries position
}
\examples{
countries_position(
  revealed_comparative_advantage =
   package_output_demo$revealed_comparative_advantage_matrix,
  country1 = "country",
  product1 = "product",
  value1 = "value",
  proximity_products = package_output_demo$proximity_matrix$proximity_products,
  product21 = "from",
  product22 = "to",
  value2 = "value",
  product_complexity_index =
   package_output_demo$complexity_measures_numeric$product_complexity_index,
  product3 = "product",
  value3 = "value",
  tbl_output = TRUE
)
}
\references{
For more information on proximity distance, complexity outlook, complexity outlook gain and its
applications see:

\insertRef{atlas2014}{economiccomplexity}
}
\keyword{functions}
