% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSelector.R
\name{makeSelector}
\alias{makeSelector}
\title{Construct a selection operator.}
\usage{
makeSelector(selector, name, description,
  supported = getAvailableRepresentations(), supported.objectives,
  supported.opt.direction = "minimize")
}
\arguments{
\item{selector}{[\code{function}]\cr
Actual selection operator.}

\item{name}{[\code{character(1)}]\cr
Name of the selector.}

\item{description}{[\code{character(1)}]\cr
Short description of how the selector works.}

\item{supported}{[\code{character}]\cr
Vector of strings/names of supported parameter representations. For example
'permutation', 'float', 'binary'.}

\item{supported.objectives}{[\code{character}]\cr
At least one of \dQuote{single-objective} or \dQuote{multi-objective}.}

\item{supported.opt.direction}{[\code{character(1-2)}]\cr
Does the selector work for maximization tasks xor minimization tasks or both?
Default is \dQuote{\code{minimize}}, which means that the selector selects
in favour of low fitness values.}
}
\value{
[\code{ecr_selector}]
  Selector object.
}
\description{
Helper function which defines a selector method, i. e., an operator which
takes the population and returns a part of it for mating or survival.
}

