% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMonitor.R
\name{makeECRMonitor}
\alias{makeECRMonitor}
\title{Factory method for monitor objects.}
\usage{
makeECRMonitor(before = NULL, step = NULL, after = NULL, ...)
}
\arguments{
\item{before}{[\code{function}]\cr
Function called one time after initialization of the EA.}

\item{step}{[\code{function}]\cr
Function applied after each iteration of the algorithm.}

\item{after}{[\code{function}]\cr
Function applied after the EA terminated.}

\item{...}{[\code{any}]\cr
Not used.}
}
\value{
[\code{ecr_monitor}]
  Monitor object.
}
\description{
Monitor objects serve for monitoring the optimization process, e.g., printing
some status messages to the console. Each monitor includes the functions
\code{before}, \code{step} and \code{after}, each being a function and expecting
a log \code{log} of type \code{ecr_logger} and \code{...} as the only parameters.
This way the logger has access to the entire log.
}
