% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.mutator.polynomial.R
\name{mutPolynomial}
\alias{mutPolynomial}
\title{Polynomial mutation.}
\usage{
mutPolynomial(ind, p = 0.2, eta = 10, lower, upper)
}
\arguments{
\item{ind}{[\code{numeric}]\cr
Numeric vector / individual to mutate.}

\item{p}{[\code{numeric(1)}]\cr
Probability of mutation of each gene.}

\item{eta}{[\code{numeric(1)}\cr
Distance parameter of the mutation distribution.}

\item{lower}{[\code{numeric}]\cr
Vector of minimal values for each parameter of the decision space.}

\item{upper}{[\code{numeric}]\cr
Vector of maximal values for each parameter of the decision space.}
}
\value{
[\code{numeric}]
}
\description{
Performs an polynomial mutation as used in the SMS-EMOA algorithm.
}
\seealso{
Other mutators: \code{\link{mutBitflip}},
  \code{\link{mutGauss}}, \code{\link{mutInsertion}},
  \code{\link{mutScramble}}, \code{\link{mutSwap}},
  \code{\link{mutUniform}}
}
