% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_neighbor_xlsx.R
\name{sd_neighbor_xlsx}
\alias{sd_neighbor_xlsx}
\title{A function to create a table of a school district and all its neighbors}
\usage{
sd_neighbor_xlsx(data_year = "2018", school_district = NULL,
  table_vars = c('Name', 'Enrollment', 'Poverty Rate', 'Percent Nonwhite',
  'Local Revenue PP', 'State Revenue PP', 'Type'))
}
\arguments{
\item{data_year}{Four digit year of master data to pull in. Options include
2013- 2018. Defaults to 2018.}

\item{school_district}{Seven digit NCESID of the school district. Default is
NULL. To find the NCESID for any school district, use
\code{\link{masterpull}} to search for your district.}

\item{table_vars}{Variable or list of variables to include in the table. Use
tables_vars = “options” to print a list of the variables. Defaults to:
Name; Enrollment; Poverty Rate; Percent Nonwhite; Local Revenue, per Pupil;
State Revenue, per Pupil; Type}
}
\value{
An excel workbook which can be written out with
  \code{openxlsx::saveWorkbook(my_table, file =
  '~/Documents/neighbor_table.xlsx', overwrite = TRUE)}
}
\description{
This function allows you to write out a table of any school
  district and its neighbors with selected data from EdBuild's master
  datafile, ready to export as a formatted excel file.
}
\examples{
\donttest{table <- sd_neighbor_xlsx(
         data_year = "2018",
         school_district = "0622710",
         table_vars = c("Name",
                       "Percent FRL",
                       "Median Household Income",
                        "State Revenue PP")
        )}
}
\seealso{
\code{\link{sd_table_xlsx}}, \code{\link{master_codebook}},
  \code{\link{masterpull}} \code{\link{neigh_diff}}
}
\keyword{EdBuild}
\keyword{difference}
\keyword{neighbors}
\keyword{table}
