% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/end_activities.R
\name{end_activities}
\alias{end_activities}
\alias{end_activities.eventlog}
\alias{end_activities.grouped_eventlog}
\title{Metric: End activities}
\usage{
end_activities(eventlog, level, append, ...)

\method{end_activities}{eventlog}(eventlog, level = c("log", "case",
  "activity", "resource", "resource-activity"), append = FALSE,
  append_column = NULL, ...)

\method{end_activities}{grouped_eventlog}(eventlog, level = c("log", "case",
  "activity", "resource", "resource-activity"), append = FALSE,
  append_column = NULL, ...)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.
\code{eventlog}.}

\item{level}{Level of granularity for the analysis: log,  case, activity, resource or resource-activity.
For more information, see \code{vignette("metrics", "edeaR")}}

\item{append}{Logical, indicating whether to append results to original event log. Ignored when level is log or trace.}

\item{...}{Deprecated arguments}

\item{append_column}{Which of the output columns to append to log, if append = T. Default column depends on chosen level.}
}
\description{
Analyse the end activities in the process.
}
\details{
\itemize{
\item On log levels, this metric shows the absolute and relative number of activities that are the last activity in one or more of the cases.
\item On the level of the specific cases, this metric provides an overview of the end activity of each case.
\item  On the activity level This metric calculates for each activity the absolute and relative number of cases that end with this activity type.
Similar to the start activities metric, the relative number is calculated as a portion of the
number of cases, being the number of \"opportunities\" that an activity could be the end activity.
The cumulative sum is added to have an insight in the number of activities that is required to cover a certain part of the total.
\item On the level of the distinct resources, an overview of which resources execute the last activity per case can be of interest for a
company. Probably this person is responsible for the correct communication to the customer.
\item  Finally, on the resource-activity level,
this metric shows for each occurring resource-activity combination the absolute and relative number of times this resource executes this
activity as an end activity in a case.}
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Compute end activities for eventlog

\item \code{grouped_eventlog}: Compute end activities for grouped eventlog
}}

\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
