% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_trim.R
\name{filter_trim}
\alias{filter_trim}
\alias{filter_trim.eventlog}
\alias{filter_trim.grouped_eventlog}
\alias{ifilter_trim}
\title{Filter: Trim cases}
\usage{
filter_trim(eventlog, start_activities, end_activities, reverse)

\method{filter_trim}{eventlog}(
  eventlog,
  start_activities = NULL,
  end_activities = NULL,
  reverse = FALSE
)

\method{filter_trim}{grouped_eventlog}(
  eventlog,
  start_activities = NULL,
  end_activities = NULL,
  reverse = FALSE
)

ifilter_trim(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{start_activities}{A vector of activity identifiers, or NULL}

\item{end_activities}{A vector of activity identifiers, or NULL}

\item{reverse}{Logical, indicating whether the selection should be reversed.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Trim cases from the first event of a set of start activities to the last event of a set of end activities.
}
\details{
One can trim cases by removing one or more activity instances
at the start and/or end of a case. Trimming is performed until all cases have a start and/or
end point belonging to a set of allowed activity labels. This filter requires a set of allowed
start activities and/or a set of allowed end activities. If one of them is not provided it will
not trim the cases at this edge.The selection can be reversed, which means that
only the trimmed events at the start and end of cases are retained. As such, this argument
allows to cut intermediate parts out of traces.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter event log

\item \code{grouped_eventlog}: Filter grouped event log
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
