% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgebundleR.R
\name{edgebundle}
\alias{edgebundle}
\title{Circle plot with bundled edges}
\usage{
edgebundle(x, tension = 0.5, cutoff = 0.1, width = NULL, fontsize = 14,
  padding = 100, nodesize = c(5, 20), directed = FALSE)
}
\arguments{
\item{x}{an appropriately structured JSON file (see vignette for details) or a
square symmetric matrix (e.g. correlation matrix) or an igraph object.}

\item{tension}{numeric between 0 and 1 giving the tension of the links}

\item{cutoff}{numeric giving the threshold dependence for linkages to be plotted}

\item{width}{the width of the plot when viewed externally}

\item{fontsize}{font size of the node labels}

\item{padding}{the padding (in px) between the inner radius of links and the
edge of the plot.  Increase this when the labels run outside the edges of
the plot.  Default: 100.}

\item{nodesize}{two element vector of the min and max node size
to scale the node circle size.  If a size is not provided for each
node, then the node size will be the max node size provided in
this argument.  Default: c(5,20).}

\item{directed}{whether or not the graph is directed. Does not work yet.
Need to think about how to implement this cleanly.}
}
\description{
Takes an appropriately structured JSON file or a square symmetric matrix (e.g. a
correlation matrix or precision matrix) and outputs a circle plot with the nodes
around the circumfrence and linkages between the connected nodes. Adapted from
the  Mike Bostock's D3 Hierarchical Edge Bundling example using the htmlwidgets
framework.
}
\examples{
\dontrun{
require(igraph)
ws_graph = watts.strogatz.game(1, 50, 4, 0.05)
edgebundle(ws_graph,tension = 0.1,fontsize = 20)
}

}

