% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menu.R
\name{menu_factorial}
\alias{menu_factorial}
\title{Prepare a factorial design}
\usage{
menu_factorial(
  trt = c(random_integer_small(), random_integer_small()),
  r = random_integer_small(),
  design = c("crd", "rcbd"),
  seed = random_seed_number()
)
}
\arguments{
\item{trt}{A vector of the number of levels for each treatment factor.}

\item{r}{The number of replications for each treatment level.}

\item{design}{The unit structure: "crd" or "rcbd". The default is "crd".}

\item{seed}{A scalar value for computational reproducibility.}
}
\value{
A recipe for factorial design.
}
\description{
Prepare a factorial design
}
\examples{
menu_factorial(trt = c(3, 2), r = 2, design = "crd")
}
\seealso{
Other recipe-designs: 
\code{\link{menu_bibd}()},
\code{\link{menu_crd}()},
\code{\link{menu_graeco}()},
\code{\link{menu_hyper_graeco}()},
\code{\link{menu_lsd}()},
\code{\link{menu_rcbd}()},
\code{\link{menu_split}()},
\code{\link{menu_strip}()},
\code{\link{menu_youden}()}
}
\concept{recipe-designs}
