library(testthat)

test_that("editrules can derive the correct info from a matrix",{
   mat <- matrix( c( 1,-2, 0
                   , 2, 0, 1
				   )
				, nrow=2
				, byrow=TRUE 
	#			, dimnames=list(c("a", "b"), c("x","y", "z"))
				)
   ei <- editrules(mat)
   expect_equal(ei$edit, c("a == 2*b", "2*a + c == 0"))
   
   mat <- matrix( c( 1,-2
                   , 2, 0
		 		       )
				    , nrow=2
				    , byrow=TRUE
                , dimnames=list(c("A", "B"), c("x","y"))
				)
   ei <- editrules(mat)
   #expect_equal(ei$name, c("A","B"))
   expect_equal(ei$edit, c("x == 2*y", "2*x == 0"))
})

test_that("getC works",{
   cond <- c( "x + y > 2"
            , "y < 10"
            )
   E <- editmatrix(cond)
   C <- getC(E)
   expect_equal(C, c(e1=2,e2=10))
})

test_that("getOps works",{
   cond <- c( "x + y > 2"
            , "y < 10"
            , "x + y == 2"
            , "y <= 10"
            , "y >= 10"
            )
   E <- editmatrix(cond)
   ops <- getOps(E)
   expect_equal(as.character(ops), c(">","<","==","<=",">="))
})