% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgrs.R
\name{rgrs}
\alias{rgrs}
\title{Relaxed Guided Random Search}
\usage{
rgrs(
  edges = NULL,
  d,
  n = NULL,
  theta = NULL,
  outlying = "N",
  skew = "N",
  stringy = "N"
)
}
\arguments{
\item{edges}{A numeric vector containing the desired edge lengths of the minimum spanning tree. If n is specified, must be NULL.}

\item{d}{the dimension of the resulting configuration.}

\item{n}{the desired number of edge lengths to simulate. If edges is specified, must be set to NULL.}

\item{theta}{Angle restriction during point proposal of the form (theta1,theta2,p), where p represents the probability of confining the proposal to [theta1,theta2]. Only used for d=2, otherwise NULL. See details for more in depth explanation.}

\item{outlying}{One of "L", "M", or "H", specifying if the simulated edge lengths should have a Low, Medium, or High outlying scagnostic value.}

\item{skew}{One of "L", "M", or "H", specifying if the simulated edge lengths should have a Low, Medium, or High skew scagnostic value.}

\item{stringy}{One of "L", "M", or "H", specifying if the simulated edge lengths should have a Low, Medium, or High stringy scagnostic value. A numeric scalar specifying a value of stringy is also accepted.}
}
\value{
An nxd matrix containing the d-dimensional locations of the points.
}
\description{
\code{rgrs} Produce a point configuration given the edge lengths of the desired minimum spanning tree
}
\details{
In 2-dimensions, when a new point is proposed, the position for the new point is determined by:

x <- x0 + r*sin(theta)
y <- y0 + r*cos(theta)

where (x0,y0) is the base point, and r is the minimum spanning tree distance. 
theta is generated from a uniform distribution on (-pi,pi). By specifying the theta argument, the
proposed theta is restricted, and is then generated from Uniform(theta1,theta2) or Uniform(-theta2,-theta1) with equal probability.
This restriction allows the user to introduce striation into their point configuration.
}
\examples{

\donttest{
# An example where edge lengths are supplied
EL <- runif(100,0,1)
rgrs(edges = EL, d = 2)
rgrs(edges = EL, d = 3) 
 
# An Example where edge lengths are simulated internally
rgrs(d=2, n=100)
rgrs(d=3, n=100)
rgrs(d=2, n=100, outlying="H")
rgrs(d=2, n=100, skew = "M")
rgrs(d=2, n=100, stringy = "H")
 
# An Example making use of theta
rgrs(d=2, n=100, theta=c(pi/4,pi/3,.5))

}
}
