% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{stan_columns_plot}
\alias{stan_columns_plot}
\title{View a plot of summary statistics after using \code{irt_stan}}
\usage{
stan_columns_plot(fit, stat = "Rhat", ...)
}
\arguments{
\item{fit}{A \code{stanfit-class} object created by \code{\link{irt_stan}}
or \code{\link[rstan]{stan}}.}

\item{stat}{A string for the statistic from the \code{summary} method for a
\code{stanfit} object to plot. The default is "Rhat" but could, for
example, be "mean" or "n_eff".}

\item{...}{Additional options (such as \code{pars} or \code{use_cache}),
passed to the \code{summary} method for a \code{stanfit} object. Not
required.}
}
\value{
A \code{ggplot} object.
}
\description{
View a plot of summary statistics after using \code{irt_stan}
}
\examples{
# Make a suitable data list:
spelling_list <- irt_data(response_matrix = spelling[, 2:5],
                          covariates = spelling[, "male", drop = FALSE],
                          formula = ~ 1 + male)

\dontrun{
# Fit a latent regression  2PL
twopl_fit <- irt_stan(spelling_list, model = "2pl_latent_reg.stan",
                      iter = 300, chains = 4)

# Get a plot showing Rhat statistics
rhat_columns(twopl_fit)

# Get a plot showing number of effective draws
rhat_columns(twopl_fit, stat = "n_eff")
}
}
\seealso{
See \code{\link[rstan]{stan_rhat}}, which provides a histogram of
  Rhat statistics.
}

