% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nat_map_2016}
\alias{nat_map_2016}
\title{(Very small) Map of Australian Electorate from 2013}
\format{An object of class \code{data.frame} with 48897 rows and 9 columns.}
\usage{
nat_map_2016
}
\description{
A dataset containing the map of the all 150 Australian electorates using the 2013 boundaries of the 
electorates (and downsampled to a 0.5\% file to allow fast plotting).
The data were obtained from the Australian Electoral Commission, and downloaded 
from \url{http://www.aec.gov.au/Electorates/gis/gis_datadownload.htm}.
Map of Australian Electorate from 2016
}
\details{
A dataset containing the map of the all 150 Australian electorates using the 2016 boundaries of the 
electorates (and downsampled to a 5\% file to allow fast plotting).
The data were obtained from the Australian Electoral Commission, and downloaded 
from \url{http://www.aec.gov.au/Electorates/gis/gis_datadownload.htm}.
}
\examples{

data(nat_map_2016)
data(nat_data_2016)
# choropleth map with area of electorate
library(ggplot2)
library(ggthemes)
ggplot(aes(map_id=id), data=nat_data_2016) +
  geom_map(aes(fill=Area_SqKm), map=nat_map_2016) +
  expand_limits(x=nat_map_2016$long, y=nat_map_2016$lat) + 
  theme_map()

}
\keyword{datasets}
