% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git-download.R
\name{twoparty_pollingbooth_download}
\alias{twoparty_pollingbooth_download}
\title{Download two party preference voting data from each polling booth, from the seven 
Australian Federal elections between 2001 and 2016.}
\format{A data frame with the following variables:
\itemize{
    \item StateAb: Abbreviation for state name    
    \item DivisionID: Electoral division ID    
    \item DivisionNm:  Electoral division name   
    \item PollingPlaceID: Polling place ID  
    \item PollingPlace: Polling place name  
    \item LNP_Votes: Count of two party preferred vote in favour of the 
    Liberal National coalition
    \item LNP_Percent: Percentage of two party preferred vote in favour 
    of the Liberal National coalition   
    \item ALP_Votes: Count of two party preferred vote in favour of the 
    Labor party
    \item ALP_Percent: Percentage of two party preferred vote in favour 
    of the Labor party     
    \item TotalVotes: Total number of votes cast     
    \item Swing: Percentage point change in two party preferred vote from 
    the previous election     
    \item PremisesPostCode: Post code of polling booth  
    \item Latitude: Coordinates        
    \item Longitude: Coordinates
    \item year: Election year
    }}
\usage{
twoparty_pollingbooth_download(...)
}
\arguments{
\item{...}{Additional arguments passed to `download.file`

Downloads and returns the two party preferred votes for candidates in the House of 
Representatives, for each polling both, in the six Australian Federal elections between
2001 and 2016.}
}
\value{
A data frame containing two party preference votes

A dataset containing two party preferred vote counts, winning candidate names, 
polling place locations, and other results for the House of Representatives from 
each of the 2001, 2004, 2007, 2010, 2013 and 2016 Australian federal elections.
Includes the count of votes for the Australian Labor Party and the count of votes 
for the Liberal-National Coalition for each polling place. This data set is obtained 
using the `twoparty_pollingbooth_download` function. The data were obtained from the 
Australian Electoral Commission.
}
\description{
Download two party preference voting data from each polling booth, from the seven 
Australian Federal elections between 2001 and 2016.
}
\examples{
\dontrun{
tpp_pp <- twoparty_pollingbooth_download()
library(dplyr)
tpp_pp \%>\% filter(year == 2016) \%>\% arrange(-LNP_Percent) \%>\% head
}

}
