% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{weighted_avg_census_sa1}
\alias{weighted_avg_census_sa1}
\title{Function to compute weighted average of Census information
using imputed populations as weights}
\usage{
weighted_avg_census_sa1(mapping_df, abs_df)
}
\arguments{
\item{mapping_df}{data frame detailing how much Census divisions intersect with each 
electoral division at the time of the election.}

\item{abs_df}{data frame holding Census information from Census year}
}
\value{
data frame with imputed Census data for electoral boundaries at the time of 
the Census
}
\description{
Function to compute weighted average of Census information
using imputed populations as weights
}
\examples{
\dontrun{
# Each 2013 electorate boundary's characteristics as at the time of the 2016 Census
mapping_c16_e13 <- allocate_electorate(centroids_ls = centroids_sa1_2016, electorates_sf = sF_13, 
census_year = "2016", election_year = "2013")

# Estimate 2016 Census data for the 2013 electorates
imputed_data_2016 <- weighted_avg_census_sa1(mapping_df = mapping_2016, abs_df = abs2016_cd)
}
}
