% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_read.R
\name{eem_read}
\alias{eem_read}
\title{Read excitation-emission fluorecence matrix (eem)}
\usage{
eem_read(file, recursive = FALSE)
}
\arguments{
\item{file}{File name or folder containing fluorescence file(s).}

\item{recursive}{logical. Should the listing recurse into directories?}
}
\value{
If \code{file} is a single filename:

  An object of class \code{eem} containing: \itemize{ \item sample The file
  name of the eem. \item x A matrix with fluorescence values. \item em
  Emission vector of wavelengths. \item ex Excitation vector of wavelengths.
  }

  If \code{file} is a folder, the function returns an object of class
  \code{eemlist} which is simply a list of \code{eem}.
}
\description{
Read excitation-emission fluorecence matrix (eem)
}
\details{
At the moment, Cary Eclipse, Aqualog and Shimadzu EEMs are
  supported.

  \code{eemR} will automatically try to determine from which
  spectrofluorometer the files originate and load the data accordingly. Note
  that EEMs are reshaped so X[1, 1] represents the fluoresence intensity at
  X[min(ex), min(em)].
}
\examples{
file <- system.file("extdata/cary/scans_day_1/", package = "eemR")
eems <- eem_read(file, recursive = TRUE)
}

