% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mapfunctions.R
\name{ggmapmerge}
\alias{ggmapmerge}
\title{Fortify a SpatialPolygonsDataFrame}
\usage{
ggmapmerge(mapobj, xid)
}
\arguments{
\item{mapobj}{Name of an S4 SpatialPolygonsDataFrame}

\item{xid}{Name of ID variable in the SpatialPolygonsDataFrame}
}
\value{
An S3 dataframe suitable for using in a gggplot2 map
}
\description{
Convenience function for fortifying SpatialPolygonsDataFrames for ggplot2 plotting.
}
\details{
This function requires maptools to be loaded and \code{\link{gpclibPermit}}
to be \code{TRUE}. This is because it depends on the \code{\link{fortify}} method in \code{\link{ggplot2}}.
}
\examples{
\dontrun{
xx <- maptools::readShapePoly(system.file("shapes/sids.shp", package="maptools")[1], IDvar="FIPSNO")
plotobj<-ggmapmerge(xx,"FIPS")
}
}

