% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohens_d.R, R/print.effectsize_difference.R
\name{cohens_d}
\alias{cohens_d}
\alias{hedges_g}
\alias{glass_delta}
\alias{print.effectsize_difference}
\title{Effect size for differences}
\usage{
cohens_d(
  x,
  y = NULL,
  data = NULL,
  pooled_sd = TRUE,
  paired = FALSE,
  ci = 0.95,
  correction
)

hedges_g(
  x,
  y = NULL,
  data = NULL,
  correction = 1,
  pooled_sd = TRUE,
  paired = FALSE,
  ci = 0.95
)

glass_delta(x, y = NULL, data = NULL, ci = 0.95, correction)

\method{print}{effectsize_difference}(x, digits = 2, append_CL = FALSE, ...)
}
\arguments{
\item{x}{A formula, a numeric vector, or a character name of one in \code{data}.
(For \code{print()} the result of one of the standardized difference functions.)}

\item{y}{A numeric vector, a grouping (character / factor) vector, a or a
character  name of one in \code{data}. Ignored if \code{x} is a formula.}

\item{data}{An optional data frame containing the variables.}

\item{pooled_sd}{If \code{TRUE} (default), a \code{\link[=sd_pooled]{sd_pooled()}} is used (assuming equal
variance). Else the mean SD from both groups is used instead.}

\item{paired}{If \code{TRUE}, the values of \code{x} and \code{y} are considered as paired.
This produces an effect size that is equivalent to the one-sample effect
size on \code{x - y}.}

\item{ci}{Confidence Interval (CI) level}

\item{correction}{Type of small sample bias correction to apply to produce
Hedges' \emph{g}. Can be \code{1} for Hedges and Olkin's original correction
(default) or \code{2} for Hunter and Schmidt's correction (see McGrath & Meyer,
2006).}

\item{digits}{Number of significant digits.}

\item{append_CL}{Should the Common Language Effect Sizes be printed as well?
Not applicable to Glass' Delta (See \code{\link[=d_to_common_language]{d_to_common_language()}})}

\item{...}{Not used.}
}
\value{
A data frame with the effect size(s) and confidence interval(s).
}
\description{
Compute effect size indices for standardized differences: Cohen's \emph{d},
Hedges' \emph{g} and Glass’s \emph{delta}. (This function returns the \strong{population}
estimate.)
\cr\cr
Both Cohen's \emph{d} and Hedges' \emph{g} are the estimated the standardized
difference between the means of two populations. Hedges' \emph{g} provides a bias
correction to Cohen's \emph{d} for small sample sizes. For sample sizes > 20, the
results for both statistics are roughly equivalent. Glass’s \emph{delta} is
appropriate when the standard deviations are significantly different between
the populations, as it uses only the \emph{second} group's standard deviation.
}
\note{
The indices here give the population estimated standardized difference.
Some statistical packages give the sample estimate instead (without
applying Bessel's correction).
}
\section{Confidence Intervals}{
Confidence intervals are estimated using the Noncentrality parameter method;
These methods searches for a the best non-central parameters (\code{ncp}s) of the
noncentral t-, F- or Chi-squared distribution for the desired
tail-probabilities, and then convert these \code{ncp}s to the corresponding effect
sizes.
}

\examples{
cohens_d(iris$Sepal.Length, iris$Sepal.Width)
hedges_g("Sepal.Length", "Sepal.Width", data = iris)

cohens_d(mpg ~ am, data = mtcars)
cohens_d(mpg ~ am, data = mtcars, pooled_sd = FALSE)
hedges_g(mpg ~ am, data = mtcars)
glass_delta(mpg ~ am, data = mtcars)

print(cohens_d(mpg ~ am, data = mtcars), append_CL = TRUE)
}
\references{
\itemize{
\item Cohen, J. (2013). Statistical power analysis for the behavioral sciences. Routledge.
\item Hedges, L. V. & Olkin, I. (1985). Statistical methods for meta-analysis. Orlando, FL: Academic Press.
\item Hunter, J. E., & Schmidt, F. L. (2004). Methods of meta-analysis: Correcting error and bias in research findings. Sage.
\item McGrath, R. E., & Meyer, G. J. (2006). When effect sizes disagree: the case of r and d. Psychological methods, 11(4), 386.
}
}
\seealso{
\code{\link[=d_to_common_language]{d_to_common_language()}} \code{\link[=sd_pooled]{sd_pooled()}}

Other effect size indices: 
\code{\link{effectsize}()},
\code{\link{eta_squared}()},
\code{\link{phi}()},
\code{\link{standardize_parameters}()}
}
\concept{effect size indices}
