% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtab.R
\name{phi}
\alias{phi}
\alias{cohens_w}
\alias{cramers_v}
\alias{normalized_chi}
\alias{pearsons_c}
\alias{oddsratio}
\alias{riskratio}
\alias{cohens_h}
\alias{cohens_g}
\title{Effect size for contingency tables}
\usage{
phi(x, y = NULL, ci = 0.95, alternative = "greater", adjust = FALSE, ...)

cohens_w(x, y = NULL, ci = 0.95, alternative = "greater", ...)

cramers_v(x, y = NULL, ci = 0.95, alternative = "greater", adjust = FALSE, ...)

normalized_chi(x, y = NULL, ci = 0.95, alternative = "greater", ...)

pearsons_c(
  x,
  y = NULL,
  ci = 0.95,
  alternative = "greater",
  adjust = FALSE,
  ...
)

oddsratio(x, y = NULL, ci = 0.95, alternative = "two.sided", log = FALSE, ...)

riskratio(x, y = NULL, ci = 0.95, alternative = "two.sided", log = FALSE, ...)

cohens_h(x, y = NULL, ci = 0.95, alternative = "two.sided", ...)

cohens_g(x, y = NULL, ci = 0.95, alternative = "two.sided", ...)
}
\arguments{
\item{x}{a numeric vector or matrix. \code{x} and \code{y} can also
    both be factors.}

\item{y}{a numeric vector; ignored if \code{x} is a matrix.  If
    \code{x} is a factor, \code{y} should be a factor of the same length.}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"greater"} (two-sided CI; default for
Cramer's \emph{V}, phi (\eqn{\phi}), and Cohen's \emph{w}), \code{"two.sided"} (default
for OR, RR, Cohen's \emph{h} and Cohen's \emph{g}) or \code{"less"} (one-sided CI).
Partial matching is allowed (e.g., \code{"g"}, \code{"l"}, \code{"two"}...). See
\emph{One-Sided CIs} in \link{effectsize_CIs}.}

\item{adjust}{Should the effect size be bias-corrected? Defaults to \code{FALSE}.}

\item{...}{Arguments passed to \code{\link[stats:chisq.test]{stats::chisq.test()}}, such as \code{p} for
goodness-of-fit. Ignored for \code{cohens_g()}.}

\item{log}{Take in or output the log of the ratio (such as in logistic models).}
}
\value{
A data frame with the effect size (\code{Cramers_v}, \code{phi} (possibly with
the suffix \verb{_adjusted}), \code{Cohens_w}, \code{normalized_chi}, \code{Odds_ratio},
\code{Risk_ratio} (possibly with the prefix \code{log_}), \code{Cohens_h}, or \code{Cohens_g})
and its CIs (\code{CI_low} and \code{CI_high}).
}
\description{
Compute Cramer's \emph{V}, phi (\eqn{\phi}), Cohen's \emph{w}, normalized Chi
(\eqn{\chi}), Pearson's contingency coefficient, Odds ratios, Risk ratios,
Cohen's \emph{h} and Cohen's \emph{g} for contingency tables or goodness-of-fit. See
details.
}
\details{
Cramer's \emph{V}, phi (\eqn{\phi}), Cohen's \emph{w}, and Pearson's \emph{C} are effect
sizes for tests of independence in 2D contingency tables. For 2-by-2 tables,
Cramer's \emph{V}, phi and Cohen's \emph{w} are identical, and are equal to the simple
correlation between two dichotomous variables, ranging between  0 (no
dependence) and 1 (perfect dependence). For larger tables, Cramer's \emph{V} or
Pearson's \emph{C} should be used, as they are bounded between 0-1. Cohen's \emph{w}
can also be used, but since it is not bounded at 1 (can be larger) its
interpretation is more difficult.
\cr \cr
For goodness-of-fit in 1D tables Cohen's \emph{W}, normalized Chi (\eqn{\chi}) or
Pearson's \emph{C} can be used. Cohen's \emph{w} has no upper bound (can be arbitrarily
large, depending on the expected distribution). Normalized Chi is an adjusted
Cohen's \emph{w}, accounting for the expected distribution, making it bounded
between 0-1. Pearson's \emph{C} is also bounded between 0-1.
\cr \cr
To summarize, for correlation-like effect sizes, we recommend:
\itemize{
\item For a 2x2 table, use \code{phi()}
\item For larger tables, use \code{cramers_v()}
\item For goodness-of-fit, use \code{normalized_chi()}
\cr \cr
For 2-by-2 contingency tables, Odds ratios, Risk ratios and Cohen's \emph{h} can
also be estimated. Note that these are computed with each \strong{column}
representing the different groups, and the \emph{first} column representing the
treatment group and the \emph{second} column baseline (or control). Effects are
given as \code{treatment / control}. If you wish you use rows as groups you must
pass a transposed table, or switch the \code{x} and \code{y} arguments.
\cr \cr
Cohen's \emph{g} is an effect size for dependent (paired) contingency tables
ranging between 0 (perfect symmetry) and 0.5 (perfect asymmetry) (see
\code{\link[stats:mcnemar.test]{stats::mcnemar.test()}}).
}
}
\section{Confidence Intervals for Cohen's g, OR, RR and Cohen's h}{
For Cohen's \emph{g}, confidence intervals are based on the proportion (\eqn{P = g
+ 0.5}) confidence intervals returned by \code{\link[stats:prop.test]{stats::prop.test()}} (minus 0.5),
which give a good close approximation.
\cr \cr
For Odds ratios, Risk ratios and Cohen's \emph{h}, confidence intervals are
estimated using the standard normal parametric method (see Katz et al., 1978;
Szumilas, 2010).
\cr \cr
See \emph{Confidence (Compatibility) Intervals (CIs)}, \emph{CIs and Significance Tests},
and \emph{One-Sided CIs} sections for \emph{phi}, Cohen's \emph{w}, Cramer's \emph{V},
Pearson's \emph{C}, and normalized Chi.
}

\section{Confidence (Compatibility) Intervals (CIs)}{

Unless stated otherwise, confidence (compatibility) intervals (CIs) are
estimated using the noncentrality parameter method (also called the "pivot
method"). This method finds the noncentrality parameter ("\emph{ncp}") of a
noncentral \emph{t}, \emph{F}, or \eqn{\chi^2} distribution that places the observed
\emph{t}, \emph{F}, or \eqn{\chi^2} test statistic at the desired probability point of
the distribution. For example, if the observed \emph{t} statistic is 2.0, with 50
degrees of freedom, for which cumulative noncentral \emph{t} distribution is \emph{t} =
2.0 the .025 quantile (answer: the noncentral \emph{t} distribution with \emph{ncp} =
.04)? After estimating these confidence bounds on the \emph{ncp}, they are
converted into the effect size metric to obtain a confidence interval for the
effect size (Steiger, 2004).
\cr\cr
For additional details on estimation and troubleshooting, see \link{effectsize_CIs}.
}

\section{CIs and Significance Tests}{

"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\examples{

## 2-by-2 tables
## -------------
RCT <-
  matrix(c(71, 30,
           50, 100), nrow = 2, byrow = TRUE,
         dimnames = list(
           Diagnosis = c("Sick", "Recovered"),
           Group = c("Treatment", "Control")))
RCT # note groups are COLUMNS

phi(RCT)
pearsons_c(RCT)

oddsratio(RCT)
oddsratio(RCT, alternative = "greater")

riskratio(RCT)

cohens_h(RCT)

## Larger tables
## -------------

M <-
  matrix(c(150, 100, 165,
           130, 50, 65,
           35, 10, 2,
           55, 40, 25), nrow = 4,
         dimnames = list(
           Music = c("Pop", "Rock", "Jazz", "Classic"),
           Study = c("Psych", "Econ", "Law")))
M

cohens_w(M)

cramers_v(M)

pearsons_c(M)


## Goodness of fit
## ---------------

Smoking_ASD <- as.table(c(ASD = 17, ASP = 11, TD = 640))

normalized_chi(Smoking_ASD)

cohens_w(Smoking_ASD)

pearsons_c(Smoking_ASD)

# Use custom expected values:
normalized_chi(Smoking_ASD, p = c(0.015, 0.010, 0.975))

cohens_w(Smoking_ASD, p = c(0.015, 0.010, 0.975))

pearsons_c(Smoking_ASD, p = c(0.015, 0.010, 0.975))





## Dependent (Paired) Contingency Tables
## -------------------------------------
Performance <-
  matrix(c(794, 150,
           86, 570), nrow = 2,
         dimnames = list(
           "1st Survey" = c("Approve", "Disapprove"),
           "2nd Survey" = c("Approve", "Disapprove")))
Performance

cohens_g(Performance)

}
\references{
\itemize{
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed.). New York: Routledge.
\item Katz, D. J. S. M., Baptista, J., Azen, S. P., & Pike, M. C. (1978). Obtaining confidence intervals for the risk ratio in cohort studies. Biometrics, 469-474.
\item Szumilas, M. (2010). Explaining odds ratios. Journal of the Canadian academy of child and adolescent psychiatry, 19(3), 227.
\item Johnston, J. E., Berry, K. J., & Mielke Jr, P. W. (2006). Measures of
effect size for chi-squared and likelihood-ratio goodness-of-fit tests.
Perceptual and motor skills, 103(2), 412-414.
\item Rosenberg, M. S. (2010). A generalized formula for converting chi-square
tests to effect sizes for meta-analysis. PloS one, 5(4), e10059.
}
}
\seealso{
\code{\link[=chisq_to_phi]{chisq_to_phi()}} for details regarding estimation and CIs.

Other effect size indices: 
\code{\link{cles}()},
\code{\link{cohens_d}()},
\code{\link{effectsize.BFBayesFactor}()},
\code{\link{eta_squared}()},
\code{\link{rank_biserial}()}
}
\concept{effect size indices}
