% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_custom.r
\name{geom_custom}
\alias{geom_custom}
\title{geom_custom}
\usage{
geom_custom(mapping = NULL, data = NULL, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{mapping}

\item{data}{data}

\item{inherit.aes}{inherit.aes}

\item{...}{arguments passed to the geom's draw_group method}
}
\value{
layer
}
\description{
Draw user-defined grobs, typically annotations, at specific locations.
}
\examples{
library(grid)
d <- data.frame(x=rep(1:3, 4), f=rep(letters[1:4], each=3))
gl <- replicate(4, matrix(sample(palette(), 9, TRUE), 3, 3), FALSE)
dummy <- data.frame(f=letters[1:4], data = I(gl))

ggplot(d, aes(f,x)) +
  facet_wrap(~f)+
  theme_bw() +
  geom_point()+
  geom_custom(data = dummy, aes(data = data, y = 2),
              grob_fun = function(x) rasterGrob(x, interpolate = FALSE,
                                                width=unit(1,"cm"),
                                                height=unit(1,"cm")))
}
