% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ei.R
\name{EI}
\alias{EI}
\title{Calculate the EI-Index for the alter-alter ties of an egor object}
\usage{
EI(object, alt.attr)
}
\arguments{
\item{object}{An \code{egor} object.}

\item{alt.attr}{\code{Character} naming grouping variable.}
}
\description{
The EI-Index is the division of the intra-group edge density and the outer-group edge
density. It is calculated for the whole network and for subgroups. The
whole network EI is a metric indicating the tendency of a network to be
clustered by the categories of a given factor variable. The EI value of a
group describes the tendency of that group within a network to be connected
[0,1) or not connected (-1,0]
to other groups. Additionally, the EI index can be employed as a measurement
for egos tendency to homo-/heteorphily - use the \code{egor::comp_ei()} command
for that version of the EI-Index.

[0,1) or not connected (-1,0]: R:0,1)\%20or\%20not\%20connected\%20(-1,0
}
\examples{
data("egor32")
EI(egor32, "sex")
}
\references{
Krackhardt, D., Stern, R.N., 1988. Informal networks and
organizational crises: an experimental simulation. Social Psychology
Quarterly 51 (2), 123-140.

Everett, M. G., & Borgatti, S. P. (2012). Categorical attribute
based centrality: E-I and G-F centrality. Social Networks, 34(4), 562-569.
}
\keyword{ego-centered}
\keyword{network}
\keyword{sna}
