% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.egor.R
\name{subset.egor}
\alias{subset.egor}
\alias{[.egor}
\title{Filter and Subset Ego-centered Datasets}
\usage{
\method{subset}{egor}(x, subset, ..., unit = attr(x, "active"))

\method{[}{egor}(x, i, j, unit = attr(x, "active"), ...)
}
\arguments{
\item{x}{an \code{\link[=egor]{egor()}} object.}

\item{subset}{either an expression evaluated on each of the rows of
the selected unit (as in the eponymous argument of \code{\link[=subset]{subset()}}) or
a function whose first argument is a row, specifying which egos,
alters, or alter-alter ties to keep. The expressions can access
variables in the calling environment; columns of the active unit,
columns of other units with which the active unit shares an ego
via \verb{ego$}, \verb{alter$}, and \verb{aatie$} as well as the following
"virtual" columns to simplify indexing: \describe{

\item{Ego index \code{.egoRow}}{ contains the index (counting from 1) of the row being
evaluated. (This can be used to access vector variables in the
calling environment.)}

\item{Alter index \code{.altRow}}{ contains the index (counting from 1) of the row number in the alter table.}

\item{Alter--alter indices \code{.srcRow} and \code{.tgtRow}}{ contain the
index (counting from 1) of the row of the alter being referenced by
\code{.srcID} and \code{.tgtID}. (This can be used to quickly access the
attributes of the alters in question.)}

}}

\item{...}{extra arguments to \code{subset} if \code{subset} is a function; otherwise unused.}

\item{unit}{a selector of the unit of analysis being affected: the
egos, the alters or the (alter-alter) ties. Note that only one
type of unit can be affected at a time. Defaults to the current
active unit selected by \code{\link[=activate.egor]{activate.egor()}}.}

\item{i}{numeric or logical vector indexing the appropriate unit.}

\item{j}{either an integer vector specifying which columns of the
filtered structure (ego, alters, or ties) to select, or a logical
vector specifying which columns to keep. Note that the special
columns .egoID, .altID, .srcID, .tgtID are not indexed by \code{j}.}
}
\value{
An \code{\link[=egor]{egor()}} object.
}
\description{
Functions to index and take subsets of \code{\link[=egor]{egor()}} objects: manipulate
egos, alters, or alter-alter ties.
}
\details{
Removing or duplicating an ego will also remove or duplicate their
alters and ties.
}
\examples{

# Generate a small sample dataset
(e <- make_egor(5,4))

# First three egos in the dataset
e[1:3,]

# Using an external vector
# (though normally, we would use e[.keep,] here)
.keep <- rep(c(TRUE, FALSE), length.out=nrow(e$ego))
subset(e, .keep)

    # Filter egos
subset(x = egor32, subset = egor32$ego$variables$sex == "m", unit="ego")
subset(x = egor32, sex == "m")

# Filter alters
subset(x = egor32, sex == "m", unit = "alter")

# Filter aaties
subset(x = egor32, weight != 0, unit = "aatie")

# Filter egos by alter variables (keep only egos that have more than 13 alters)
subset(x = egor32, nrow(alter) > 13, unit = "alter")

# Filter alters by ego variables (keep only alters that have egos from Poland)
subset(x = egor32, ego$country == "Poland", unit = "ego")

# Filter edges by alter variables (keep only edges between alters where `sex == "m"`)
subset(x = egor32, all(alter$sex == "m"), unit = "aatie")
}
