% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phfunc.R
\name{phfunc}
\alias{phfunc}
\title{Loglihood function of a proportional hazards regression}
\usage{
phfunc(beta = NULL, lambda, p, X = NULL, Y, offset = rep(0, length(Y)),
  ord = 2, pfixed = FALSE, dist = "weibull")
}
\arguments{
\item{beta}{Regression parameters}

\item{lambda}{The scale paramater}

\item{p}{The shape parameter}

\item{X}{The design (covariate) matrix.}

\item{Y}{The response, a survival object.}

\item{offset}{Offset.}

\item{ord}{ord = 0 means only loglihood, 1 means score vector as well, 2
loglihood, score and hessian.}

\item{pfixed}{Logical, if TRUE the shape parameter is regarded as a known
constant in the calculations, meaning that it is not cosidered in the
partial derivatives.}

\item{dist}{Which distribtion? The default is "weibull", with the
alternatives "loglogistic" and "lognormal".}
}
\value{
A list with components \item{f}{The log likelihood. Present if
\code{ord >= 0}} \item{fp}{The score vector. Present if \code{ord >= 1}}
\item{fpp}{The negative of the hessian. Present if \code{ord >= 2}}
}
\description{
Calculates minus the log likelihood function and its first and second order
derivatives for data from a Weibull regression model.
}
\details{
Note that the function returns log likelihood, score vector and minus
hessian, i.e. the observed information. The model is 
\deqn{S(t; p, \lambda, \beta, z) = S_0((t / \lambda)^p)^{e^(z \beta)}}{S(t; p, lambda, beta, z) = S_0((t / lambda)^p)^exp(z beta)}
}
\seealso{
\code{\link{phreg}}
}
\author{
Göran Broström
}
\keyword{distribution}
\keyword{survival}
