% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_plot.R
\name{wrf_plot}
\alias{wrf_plot}
\title{Simple plot from wrf emission file}
\usage{
wrf_plot(
  file = file.choose(),
  name = NA,
  time = 1,
  nivel = 1,
  barra = TRUE,
  lbarra = 0.2,
  col = cptcity::cpt(n = 20, rev = TRUE),
  map = NULL,
  skip = FALSE,
  no_title = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{file}{emission file name}

\item{name}{pollutant name}

\item{time}{time from emission file}

\item{nivel}{level from the emission file}

\item{barra}{barblot if TRUE}

\item{lbarra}{length of barplot}

\item{col}{color vector}

\item{map}{function call to plot map lines, points and annotation (experimental)}

\item{skip}{logical, skip plot of constant valuess}

\item{no_title}{no title plot}

\item{verbose}{if TRUE print some information}

\item{...}{Arguments to be passed to plot methods}
}
\value{
a plot of a WRF var.
}
\description{
Create a quick plot from wrf emission file
}
\note{
If the file contains levels (kemit>1), and one frame (auxinput5_interval_m = 1)
time with control the level which will be ploted

In case of an error related to plot.new() margins lbarra must be adjusted
}
\examples{
\donttest{

dir.create(file.path(tempdir(), "EMISS2"))
wrf_create(wrfinput_dir = system.file("extdata",
                                    package = "eixport"),
          wrfchemi_dir = file.path(tempdir(), "EMISS2"))

# get the name of created file
files <- list.files(path = file.path(tempdir(), "EMISS2"),
                   pattern = "wrfchemi",
                   full.names = TRUE)

# load end write some data in this emission file
data(Lights)
to_wrf(Lights, files[1], total = 1521983, name = "E_CO")

wrf_plot(files[1], "E_CO", col = cptcity::cpt(n = 14))
}
}
\seealso{
\code{\link{Lights}}, \code{\link{to_wrf}} and \code{\link{wrf_create}}
}
\author{
Daniel Schuch
}
