% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_stats.R
\name{field_stats}
\alias{field_stats}
\title{Search field statistics}
\usage{
field_stats(
  conn,
  fields = NULL,
  index = NULL,
  level = "cluster",
  body = list(),
  raw = FALSE,
  asdf = FALSE,
  ...
)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{fields}{A list of fields to compute stats for. optional}

\item{index}{Index name, one or more}

\item{level}{Defines if field stats should be returned on a per index level
or on a cluster wide level. Valid values are 'indices' and 'cluster'
(default)}

\item{body}{Query, either a list or json}

\item{raw}{(logical) Get raw JSON back or not}

\item{asdf}{(logical) If \code{TRUE}, use \code{\link[jsonlite]{fromJSON}}
to parse JSON directly to a data.frame. If \code{FALSE} (Default), list
output is given.}

\item{...}{Curl args passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Search field statistics
}
\details{
The field stats api allows you to get statistical properties of a
field without executing a search, but looking up measurements that are
natively available in the Lucene index. This can be useful to explore a
dataset which you don't know much about. For example, this allows creating
a histogram aggregation with meaningful intervals based on the min/max range
of values.

The field stats api by defaults executes on all indices, but can execute on
specific indices too.
}
\note{
Deprecated in Elasticsearch versions equal to/greater than 5.4.0
}
\examples{
\dontrun{
x <- connect()

if (gsub("\\\\.", "", x$ping()$version$number) < 500) {
  field_stats(x, body = '{ "fields": ["speaker"] }', index = "shakespeare")
  ff <- c("scientificName", "continent", "decimalLatitude", "play_name", 
    "speech_number")
  field_stats(x, "play_name")
  field_stats(x, "play_name", level = "cluster")
  field_stats(x, ff, level = "indices")
  field_stats(x, ff)
  field_stats(x, ff, index = c("gbif", "shakespeare"))

  # can also pass a body, just as with Search()
  # field_stats(x, body = list(fields = "rating")) # doesn't work
  field_stats(x, body = '{ "fields": ["scientificName"] }', index = "gbif")

  body <- '{
    "fields" : ["scientificName", "decimalLatitude"]
  }'
  field_stats(x, body = body, level = "indices", index = "gbif")
}
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/5.6/search-field-stats.html}
}
\seealso{
\code{\link[=field_caps]{field_caps()}}
}
