% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-gemini.R
\name{chat_google_gemini}
\alias{chat_google_gemini}
\alias{chat_google_vertex}
\alias{models_google_gemini}
\alias{models_google_vertex}
\title{Chat with a Google Gemini or Vertex AI model}
\usage{
chat_google_gemini(
  system_prompt = NULL,
  base_url = "https://generativelanguage.googleapis.com/v1beta/",
  api_key = NULL,
  model = NULL,
  params = NULL,
  api_args = list(),
  echo = NULL
)

chat_google_vertex(
  location,
  project_id,
  system_prompt = NULL,
  model = NULL,
  params = NULL,
  api_args = list(),
  echo = NULL
)

models_google_gemini(
  base_url = "https://generativelanguage.googleapis.com/v1beta/",
  api_key = NULL
)

models_google_vertex(location, project_id)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{base_url}{The base URL to the endpoint; the default uses OpenAI.}

\item{api_key}{API key to use for authentication.

You generally should not supply this directly, but instead set the \code{GOOGLE_API_KEY} environment variable.
The best place to set this is in \code{.Renviron},
which you can easily edit by calling \code{usethis::edit_r_environ()}.
For Gemini, you can alternatively set \code{GEMINI_API_KEY}.}

\item{model}{The model to use for the chat (defaults to "gemini-2.0-flash").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.
Use \code{models_google_gemini()} to see all options.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}

\item{location}{Location, e.g. \code{us-east1}, \code{me-central1}, \code{africa-south1}.}

\item{project_id}{Project ID.}
}
\value{
A \link{Chat} object.
}
\description{
Google's AI offering is broken up into two parts: Gemini and Vertex AI.
Most enterprises are likely to use Vertex AI, and individuals are likely
to use Gemini.

Use \code{\link[=google_upload]{google_upload()}} to upload files (PDFs, images, video, audio, etc.)
\subsection{Authentication}{

By default, \code{chat_google_gemini()} will use Google's default application
credentials if there is no API key provided. This requires the \pkg{gargle}
package.

It can also pick up on viewer-based credentials on Posit Connect. This in
turn requires the \pkg{connectcreds} package.
}
}
\examples{
\dontrun{
chat <- chat_google_gemini()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_cortex_analyst}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
