% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-azure.R
\name{chat_azure_openai}
\alias{chat_azure_openai}
\title{Chat with a model hosted on Azure OpenAI}
\usage{
chat_azure_openai(
  endpoint = azure_endpoint(),
  model,
  params = NULL,
  api_version = NULL,
  system_prompt = NULL,
  api_key = NULL,
  token = deprecated(),
  credentials = NULL,
  api_args = list(),
  echo = c("none", "output", "all"),
  api_headers = character(),
  deployment_id = deprecated()
)
}
\arguments{
\item{endpoint}{Azure OpenAI endpoint url with protocol and hostname, i.e.
\verb{https://\{your-resource-name\}.openai.azure.com}. Defaults to using the
value of the \code{AZURE_OPENAI_ENDPOINT} environment variable.}

\item{model}{The \strong{deployment id} for the model you want to use.}

\item{params}{Common model parameters, usually created by \code{\link[=params]{params()}}.}

\item{api_version}{The API version to use.}

\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{api_key}{API key to use for authentication.

You generally should not supply this directly, but instead set the \code{AZURE_OPENAI_API_KEY} environment variable.
The best place to set this is in \code{.Renviron},
which you can easily edit by calling \code{usethis::edit_r_environ()}.}

\item{token}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} A literal Azure token to use
for authentication. Deprecated in favour of ambient Azure credentials or
an explicit \code{credentials} argument.}

\item{credentials}{A list of authentication headers to pass into
\code{\link[httr2:req_headers]{httr2::req_headers()}}, a function that returns them, or \code{NULL} to use
\code{token} or \code{api_key} to generate these headers instead. This is an escape
hatch that allows users to incorporate Azure credentials generated by other
packages into \pkg{ellmer}, or to manage the lifetime of credentials that
need to be refreshed.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}

\item{api_headers}{Named character vector of arbitrary extra headers appended
to every chat API call.}

\item{deployment_id}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{model} instead.}
}
\value{
A \link{Chat} object.
}
\description{
The \href{https://azure.microsoft.com/en-us/products/ai-services/openai-service}{Azure OpenAI server}
hosts a number of open source models as well as proprietary models
from OpenAI.
\subsection{Authentication}{

\code{chat_azure_openai()} supports API keys and the \code{credentials} parameter, but
it also makes use of:
\itemize{
\item Azure service principals (when the \code{AZURE_TENANT_ID}, \code{AZURE_CLIENT_ID},
and \code{AZURE_CLIENT_SECRET} environment variables are set).
\item Interactive Entra ID authentication, like the Azure CLI.
\item Viewer-based credentials on Posit Connect. Requires the \pkg{connectcreds}
package.
}
}
}
\examples{
\dontrun{
chat <- chat_azure_openai(deployment_id = "gpt-4o-mini")
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_aws_bedrock}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
