% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.run.R
\name{elo.run}
\alias{elo.run}
\alias{elo.run}
\alias{print.elo.run}
\title{Calculate Elos for a series of matches}
\usage{
elo.run(formula, data, na.action, subset, k = NULL, initial.elo = NULL, ...)

\method{print}{elo.run}(x, ...)
}
\arguments{
\item{formula}{A formula. See "details", below.}

\item{data}{A \code{data.frame} in which to look for objects in \code{formula}.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{subset}{An optional vector specifying a subset of observations.}

\item{k}{A constant k-value. See "details", below.}

\item{initial.elo}{An optional named vector containing initial Elo ratings for all teams in \code{formula}.}

\item{...}{Other arguments (not used at this time).}

\item{x}{An object of class \code{"elo.run"}.}
}
\value{
An object of class \code{"elo.run"}.
}
\description{
Calculate Elos for a series of matches.
}
\details{
\code{formula} is usually of the form \code{wins.A ~ team.A + team.B}, where \code{team.A} and \code{team.B}
  are character vectors or factors denoting which two teams played, and \code{wins.A} is between 0 and 1,
  denoting whether team A won or lost (or something between).

It is also acceptable for either \code{team.A} or \code{team.B} to be a numeric column (if, for example,
  the Elo of one team or the other is known or fixed). If both are numeric, a warning will be issued,
  and results will be calculated using \code{\link{elo.calc}}.

\code{formula} accepts two special functions in it. \code{k()} allows for complicated Elo updates. For
  constant Elo updates, use the \code{k = } argument instead of this special function.
  \code{adjust()} allows for Elos to be adjusted for, e.g., home-field advantage. The second argument
  to this function can be a scalar or vector of appropriate length. See the examples.
}
\examples{
data(tournament)
elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
        data = tournament, k = 20)

# Create non-constant 'k'
elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor +
        k(20*log(abs(points.Home - points.Visitor) + 1)), data = tournament)

# Adjust Elo for, e.g., home-field advantage
elo.run(score(points.Home, points.Visitor) ~ adjust(team.Home, 10) + team.Visitor,
        data = tournament, k = 20)

tournament$home.field <- 10
elo.run(score(points.Home, points.Visitor) ~ adjust(team.Home, home.field) + team.Visitor,
        data = tournament, k = 20)

}
\seealso{
\code{\link{elo.run}}
}
