% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{auc.elo}
\alias{auc.elo}
\alias{auc.elo.run}
\alias{auc.elo.glm}
\alias{auc.elo.running}
\alias{auc.elo.markovchain}
\alias{auc.elo.winpct}
\alias{auc.elo.colley}
\title{Calculate AUC on an \code{elo.run} object}
\usage{
\method{auc}{elo.run}(object, ...)

\method{auc}{elo.glm}(object, ...)

\method{auc}{elo.running}(object, running = TRUE, ...)

\method{auc}{elo.markovchain}(object, ...)

\method{auc}{elo.winpct}(object, ...)

\method{auc}{elo.colley}(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link{elo.run}}.}

\item{...}{Other arguments (not used at this time).}

\item{running}{logical, denoting whether to use the running predicted values.}
}
\value{
The AUC of the predicted Elo probabilities and the actual win results.
}
\description{
Calculate AUC on an \code{elo.run} object
}
\references{
Adapted from code here:
  \url{https://stat.ethz.ch/pipermail/r-help/2005-September/079872.html}
}
\seealso{
\code{pROC::\link[pROC]{auc}}, \code{\link{elo.run}}.
}
