% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{make_barplot_on_synergy_subset_stats}
\alias{make_barplot_on_synergy_subset_stats}
\title{Bar plot of observed synergy subsets}
\usage{
make_barplot_on_synergy_subset_stats(
  synergy.subset.stats,
  threshold.for.subset.removal,
  bottom.margin,
  cell.line = NULL
)
}
\arguments{
\item{synergy.subset.stats}{integer vector with values the amount of models
that predicted each synergy subset, defined as a comma-separated string of
drug combinations in the \emph{names} attribute of the vector}

\item{threshold.for.subset.removal}{integer. Use it to discard elements of
the \code{synergy.subset.stats} vector that are strictly less than the
specified threshold}

\item{bottom.margin}{integer used to vertically fit in the names of the drug
combinations in the x-axis (specified in inches). The best \code{bottom.margin}
value depends on the \emph{maximum size} of a synergy subset as defined in the
\code{names} attribute of the \code{synergy.subset.stats}.
Some rules of thumb are:
size = 1 => bottom.margin = 4,
size = 2 => bottom.margin = 6,
size = 3 => bottom.margin = 9,
size = 4 => bottom.margin = 12, etc.}

\item{cell.line}{string. The name of the cell line to be used in the title
of the produced plot. Default value: NULL (the cell line name will not be
added to the title).}
}
\description{
Use this function to easily make a barplot that shows the amount of models
that predicted each synergy subset out of the set of all observed synergies.
}
