% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_avg_state_diff_graph}
\alias{plot_avg_state_diff_graph}
\title{Plot the graph of average state differences (igraph)}
\usage{
plot_avg_state_diff_graph(net, diff, layout = NULL, title)
}
\arguments{
\item{net}{igraph graph object}

\item{diff}{numeric vector. Every value is in the [-1,1] interval and
represents the average activity difference of each node. The node names have
to be specified in the \emph{names} attribute of the given vector. For example,
\code{diff} could be the result of using the function
\code{\link{get_avg_activity_diff_based_on_tp_predictions}}.}

\item{layout}{a (nx2) numeric matrix of x-y coordinates (2 columns) for each
of the nodes (n) in the \code{net} igraph object. If NULL, we use the default
layout provided by \code{\link[igraph]{layout_nicely}}.}

\item{title}{string. The title of the igraph plot}
}
\description{
This function uses the \code{\link[igraph]{plot.igraph}} package to plot a network
of nodes. The nodes are positioned according to the specified coordinates
given by the \code{layout} parameter and the colors are derived using the
\code{diff} values and the \code{\link{get_node_colors}} function. The color
of each node indicates how much more inhibited or active that node is, when
comparing the average model classified in the 'good' category vs the average
'bad' one.
}
\examples{
topology.file = system.file("extdata", "example.sif", package = "emba", mustWork = TRUE)
net = construct_network(topology.file)
diff = c(-0.95,-0.05,0.46,0.39,-0.04,0.72,-0.12,-0.51,-0.86,-0.80)
names(diff) = c("A","C","B","D","W","I","E","J","F","K")
plot_avg_state_diff_graph(net, diff, title = "TEST")

}
\seealso{
\code{\link{get_node_colors}}

Other network plotting functions: 
\code{\link{plot_avg_link_operator_diff_graphs}()},
\code{\link{plot_avg_link_operator_diff_graph}()},
\code{\link{plot_avg_state_diff_graph_vis}()},
\code{\link{plot_avg_state_diff_graphs}()}
}
\concept{network plotting functions}
