% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woe.R
\name{add_woe}
\alias{add_woe}
\title{Add WoE in a data frame}
\usage{
add_woe(.data, outcome, ..., dictionary = NULL, prefix = "woe")
}
\arguments{
\item{.data}{A tbl. The data.frame to plug the new woe version columns.}

\item{outcome}{The bare name of the outcome variable.}

\item{...}{Bare names of predictor variables, passed as you would pass
variables to \code{dplyr::select()}. This means that you can use all the
helpers like \code{starts_with()} and \code{matches()}.}

\item{dictionary}{A tbl. If NULL the function will build a dictionary with
those variables passed to \code{...}. You can pass a custom dictionary too,
see \code{\link[=dictionary]{dictionary()}} for details.}

\item{prefix}{A character string that will be the prefix to the resulting new
variables.}
}
\value{
A tibble with the original columns of .data plus the woe columns
wanted.
}
\description{
A tidyverse friendly way to plug WoE versions of a set of predictor variables
against a given binary outcome.
}
\details{
You can pass a custom dictionary to \code{\link[=add_woe]{add_woe()}}. It must have the exactly the
same structure of the output of \code{\link[=dictionary]{dictionary()}}. One easy way to do this is to
tweak a output returned from it.
}
\examples{

mtcars \%>\% add_woe("am", cyl, gear:carb)
}
