% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stages.R
\docType{data}
\name{stages}
\alias{stages}
\title{Database of of embryonic development and thermosensitive period of development for sex determination}
\format{A list with dataframes including attributes}
\usage{
stages
}
\description{
Database of embryonic development and thermosensitive period of development for sex 
determination.
}
\details{
Database of embryonic development and thermosensitive period of development for sex determination
}
\examples{
\dontrun{
library(embryogrowth)
data(stages)
names(stages)
levels(as.factor(stages$Species))
}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\references{
Pieau, C., Dorizzi, M., 1981. Determination of temperature sensitive 
stages for sexual differentiation of the gonads in embryos of the turtle, 
Emys orbicularis. Journal of Morphology 170, 373-382.\cr
Yntema, C.L., Mrosovsky, N., 1982. Critical periods and pivotal temperatures for 
sexual differentiation in loggerhead sea turtles. Canadian Journal of 
Zoology-Revue Canadienne de Zoologie 60, 1012-1016.\cr
Kaska, Y., Downie, R., 1999. Embryological development of sea turtles (Chelonia mydas, 
Caretta caretta) in the Mediterranean. Zoology in the Middle East 19, 55-69.\cr
Greenbaum, E., 2002. A standardized series of embryonic stages for the emydid 
turtle Trachemys scripta. Canadian Journal of Zoology-Revue Canadienne de 
Zoologie 80, 1350-1370.
}
\seealso{
Other Functions.for.temperature.dependent.sex.determination: \code{\link{STSRE_TSD}},
  \code{\link{TSP.list}}, \code{\link{predict.tsd}},
  \code{\link{tsd_MHmcmc_p}}, \code{\link{tsd_MHmcmc}},
  \code{\link{tsd}}
}
\keyword{datasets}

