% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEforR.R
\name{SEforR}
\alias{SEforR}
\title{Estimate the standard error for a set of parameters}
\usage{
SEforR(NestsResult = NULL, parameters = NULL, fixed.parameters = NULL,
  temperatures = NULL, derivate = NULL, test = NULL, M0 = NULL,
  series = "all", weight = NULL, hessian = FALSE)
}
\arguments{
\item{NestsResult}{A NestsResult file generated by searchR}

\item{parameters}{A set of parameters if result is not provided.}

\item{fixed.parameters}{Another set of parameters if result is not provided.}

\item{temperatures}{Timeseries of temperatures formatted using formatNests(). Will replace the one in result.}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear}

\item{test}{Mean and SD of size of hatchlings}

\item{M0}{Measure of hatchling size proxi at laying date}

\item{series}{The name or number of the series to be used}

\item{weight}{Weights of the different nests to estimate likelihood}

\item{hessian}{If TRUE, will return a list with both the Hessian matrix and SE estimates}
}
\value{
A vector of standard errors estimate
}
\description{
It is an alternative to MCMC using the Fisher Information Matrix.\cr
If too many temperatures without information are included, the estimation will fail.
}
\details{
SEforR estimates the standard error for a set of parameters
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p)
newp <- GenerateAnchor(nests=resultNest_4p, temperatures=seq(from=20,
 to=35, length.out=10))
SE <- SEforR(NestsResult=resultNest_4p, parameters=newp)
SE <- structure(c(NA, NA, 1.18147243592998, 0.610526666309349, 0.496674180881528, 
0.283356315073372, 0.162524360284674, 0.265653521222035, 1.33618216197102, 
14.7268588035904), .Names = c("293.15", "294.816666666667", "296.483333333333", 
"298.15", "299.816666666667", "301.483333333333", "303.15", "304.816666666667", 
"306.483333333333", "308.15"))
plotR(result=resultNest_4p, parameters=newp, ylim=c(0,0.4), SE=SE)
}
}
\author{
Marc Girondot
}

