% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsd_MHmcmc_p.R
\name{tsd_MHmcmc_p}
\alias{tsd_MHmcmc_p}
\title{Generates set of parameters to be used with tsd_MHmcmc()}
\usage{
tsd_MHmcmc_p(result = stop("An output from tsd() must be provided"),
  accept = FALSE)
}
\arguments{
\item{result}{An object obtained after a tsd fit}

\item{accept}{If TRUE, the script does not wait user information}
}
\value{
A matrix with the parameters
}
\description{
Interactive script used to generate set of parameters to be 
used with tsd_MHmcmc().
}
\details{
tsd_MHmcmc_p generates set of parameters to be used with tsd_MHmcmc()
}
\examples{
\dontrun{
library(embryogrowth)
eo <- subset(Database_TSD, Species=="Emys orbicularis", c("Males", "Females", 
                                       "Incubation.temperature"))
eo_logistic <- with(eo, tsd(males=Males, females=Females, 
                                 temperatures=Incubation.temperature))
pMCMC <- tsd_MHmcmc_p(eo_logistic, accept=TRUE)
}
}
\seealso{
Other Functions for temperature-dependent sex determination: \code{\link{DatabaseTSD}},
  \code{\link{P_TRT}}, \code{\link{TSP.list}},
  \code{\link{predict.tsd}}, \code{\link{stages}},
  \code{\link{tsd_MHmcmc}}, \code{\link{tsd}}
}
\author{
Marc Girondot
}
\concept{Functions for temperature-dependent sex determination}
