% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.emdi.R
\name{summary.emdi}
\alias{summary.emdi}
\title{Summarize an emdiObject}
\usage{
\method{summary}{emdi}(object, ...)
}
\arguments{
\item{object}{an object of type "emdi", representing point and MSE
estimates. Objects differ depending on the estimation method: direct 
vs. model-based.}

\item{...}{additional arguments that are not used in this method}
}
\value{
an object of type "summary.emdi" with following
components:
\item{out_of_smp}{if model-based estimation, number of out-of-sample domains 
equivalent to \code{N_dom_unobs} (see \code{\link{emdiObject}}).}
\item{in_smp}{number of in-sample domains equivalent to \code{N_dom_smp}
             (see \code{\link{emdiObject}}).}
\item{size_smp}{number of units in sample equivalent to \code{N_smp}
(see \code{\link{emdiObject}}).}
\item{size_pop}{if model-based estimation, number of units in population equivalent to \code{N_pop}
(see \code{\link{emdiObject}}).}
\item{size_dom}{a data frame with rows Sample_domains and Population_domains 
(if model-based estimation) representing summary statisitics of the sample 
sizes across domains of sample and population data respectively.}
\item{transform}{if model-based estimation, a data frame with columns 
                 Transformation, Method, Optimal_lambda and Shift_parameter representing the
                 chosen transformation type and estimation method for lambda
                 as well as their results.}
\item{normality}{if model-based estimation, a data frame with columns Skewness, 
                 Kurtosis, Shapiro_W and Shapiro_p where the latter two represent
                 the results of a Shapiro-Wilks-Test for normality.
                 Rows correspond to Pearson residuals and random effects
                 of the nested error regression model. The functions
                 \code{\link{skewness}} and \code{\link{kurtosis}} are from
                 the package \pkg{moments}. Details for the Shapiro-Wilks-Test
                 are provided by \code{\link{shapiro.test}}.}
\item{icc}{if model-based estimation, the value of the intraclass coefficient.}
\item{coeff_determ}{if model-based estimation, a data frame with colums R2, 
                    ICC, Marginal_R2 and Conditional_R2 representing the coefficient of
                    determination of a linear model without random effect,
                    the intracluster correlation and two R2 measures
                    for linear mixed models from the \pkg{MuMin} package
                    obtained by function \code{\link{r.squaredGLMM}}.}                  
\item{call}{a list containing an image of the function call that produced the
            object.}
}
\description{
Additional information about the data and model in small area estimation 
methods and components of an emdi object are extracted. The returned object 
is suitable for printing  with the \code{print.summary.emdi} method.
}
\examples{
\dontrun{
# Loading data - population and sample data
data("eusilcA_pop")
data("eusilcA_smp")
  
# Example with two additional indicators
emdi_model <- ebp(fixed = eqIncome ~ gender + eqsize + cash + 
self_empl + unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + 
fam_allow + house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
threshold = function(y){0.6 * median(y)}, L= 50, MSE = TRUE, B = 50, 
custom_indicator = list( my_max = function(y, threshold){max(y)},
my_min = function(y, threshold){min(y)}), na.rm = TRUE, cpus = 1)

# Receive first overview
summary(emdi_model)
}
}
\seealso{
\code{\link{emdiObject}}, \code{\link{direct}}, \code{\link{ebp}}, 
\code{\link{r.squaredGLMM}}, \code{\link{skewness}}, \code{\link{kurtosis}},
\code{\link{shapiro.test}}
}
