% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/learning-curve.r
\name{learning_curve}
\alias{learning_curve}
\title{Learning curve analysis}
\usage{
learning_curve(procedure, x, y, test_fraction, nfold = 100, ...,
  .verbose = TRUE)
}
\arguments{
\item{procedure}{\code{\link{modeling_procedure}}.}

\item{x}{Dataset descriptors.}

\item{y}{Response.}

\item{test_fraction}{Fraction of dataset to hold out, i.e. use as test set. Defaults
20 logarithmically distributed values ranging from all but 5 observations
per class in the largest test set to only 5 observations per class in
the smallest test set.}

\item{nfold}{How many holdout folds that should be calculated.}

\item{...}{Sent to \code{\link{evaluate}}.}

\item{.verbose}{Whether to print an activity log. Set to \code{-1} to
also suppress output generated from the procedure's functions.}
}
\description{
This function studies the change in permformance as the sizes of the training
set is varied. In case the studied modeling procedures cannot
produce models on the smallest training sets, please use
\code{.return_error=TRUE} (see \code{\link{evaluate}}.
}
\examples{
options(emil_max_indent=3)
lc <- learning_curve(c(Linear="lda", Quadratic="qda"),
                     iris[-5], iris$Species, test_fraction=7:2/10)
plot(lc)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\references{
Richard O Duda, Peter E Hart, and David G Stork. Pattern
  Classification. Wiley, 2nd edition, 2000. ISBN 978-0-471-05669-0.
}

