% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifiers.R
\name{emoji_modifier_extract}
\alias{emoji_modifier_extract}
\title{Extract Modifiers from Emojis}
\usage{
emoji_modifier_extract(x)
}
\arguments{
\item{x}{Characters, vector of emojis.}
}
\value{
list of character vectors.
}
\description{
Extract Modifiers from Emojis
}
\details{
This function is vectorized. See \link{emoji_modifiers} for full list of modified
emojis and their unmodified state.
}
\examples{
waving_hands <- emojis$emoji[grepl("waving hand", emojis$name)]
waving_hands

emoji_modifier_extract(waving_hands)

set.seed(1234)
emoji_sample <- sample(emojis$emoji, 10)
emoji_sample

emoji_modifier_extract(emoji_sample)
}
