% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMST3D.R
\name{plotMST3D}
\alias{plotMST3D}
\title{3D Minimum Spanning Tree Plot}
\usage{
plotMST3D(tree, x = 1, y = 2, z = 3, col.pts = "black",
  col.segts = "black", angle = 40, ...)
}
\arguments{
\item{tree}{a \code{MST} class object returned by the \code{ComputeMST()} 
function.}

\item{x}{the numeric position or the name of the column to be used as the x 
coordinates of points in the plot.}

\item{y}{the numeric position or the name of the column to be used as the y 
coordinates of points in the plot.}

\item{z}{the numeric position or the name of the column to be used as the z 
coordinates of points in the plot.}

\item{col.pts}{color of points (vertices/nodes) in the plot.}

\item{col.segts}{color of segments (edges) in the plot.}

\item{angle}{angle between x and y axis (Attention: result depends on 
scaling).}

\item{...}{further graphical parameters.}
}
\description{
Plots a 3D MST by producing a point cloud with segments as a 
    'scatterplot3d' graphic.
}
\examples{

## 3D artificial data:
n1 = 12
n2 = 22
n3 = 7
n = n1+n2+n3
set.seed(1984)

mean_vector <- sample(seq(1, 10, by=2), 3)
sd_vector <- sample(seq(0.01, 0.8, by=0.01), 3)
c1 <- matrix(rnorm(n1*3,mean=mean_vector[1],sd=.3), n1, 3)
c2 <- matrix(rnorm(n2*3,mean=mean_vector[2],sd=.5), n2, 3)
c3 <- matrix(rnorm(n3*3,mean=mean_vector[3],sd=1), n3, 3)
d<-rbind(c1, c2, c3)

## MST:
out <- ComputeMST(d)

## 3D PLOT:
plotMST3D(out)

}
