% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-bas_webservices.R
\name{runBASwebservice_pho2sylCanonical}
\alias{runBASwebservice_pho2sylCanonical}
\title{Adds syllabified word labels to a word level that already contains canonical pronunciations.}
\usage{
runBASwebservice_pho2sylCanonical(handle, canoAttributeDefinitionName,
  language, canoSylAttributeDefinitionName = "KAS", params = list(),
  patience = 0, resume = FALSE, verbose = TRUE)
}
\arguments{
\item{handle}{emuDB handle}

\item{canoAttributeDefinitionName}{name of the attribute (not level!) containing a canonical pronunciation of the words.}

\item{language}{language(s) to be used. If you pass a single string (e.g. "deu-DE"), this language will be used for all bundles.
Alternatively, you can select the language for every bundle individually. To do so, you must pass a data frame with the columns
session, bundle, language. This data frame must contain one row for every bundle in your emuDB.
Up-to-date lists of the languages accepted by all webservices can be found here:
\url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}}

\item{canoSylAttributeDefinitionName}{attribute name for syllabified canonical pronunciations of words}

\item{params}{named list of parameters to be passed on to the webservice. It is your own responsibility to
ensure that these parameters are compatible with the webservice API
(see \url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}).
Some options accepted by the API (e.g. output format) cannot be set when calling a webservice from within emuR,
and will be overridden.}

\item{patience}{If a web service call fails, it is repeated a further n times, with n being the value of patience.
Must be set to a value between 0 and 3.}

\item{resume}{If a previous call to this function has failed (and you think you have fixed the issue
that caused the error), you can set resume=TRUE to recover any progress made up to that point. This
will only work if your R temporary directory has not been deleted or emptied in the meantime.}

\item{verbose}{Display progress bars and other information}
}
\description{
This function calls the webservice Pho2Syl to add syllabified canonical pronunciation labels
to a word level that already contains unsyllabified canonical pronunciation labels (as can be
derived using \link{runBASwebservice_g2pForPronunciation}). \strong{This function requires an internet
connection.}
}
\seealso{
Other BAS webservice functions: \code{\link{runBASwebservice_all}},
  \code{\link{runBASwebservice_chunker}},
  \code{\link{runBASwebservice_g2pForPronunciation}},
  \code{\link{runBASwebservice_g2pForTokenization}},
  \code{\link{runBASwebservice_maus}},
  \code{\link{runBASwebservice_minni}},
  \code{\link{runBASwebservice_pho2sylSegmental}}
}
\concept{BAS webservice functions}
