% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enaMTI.R
\name{enaMTI}
\alias{enaMTI}
\title{Mixed Trophic Impacts (MTI) Analysis}
\usage{
enaMTI(x, zero.na = TRUE, balance.override = FALSE)
}
\arguments{
\item{x}{a network object.  This includes all weighte dflows into and out of
each node.  It must also include the "Living" vector that identifies the
living (TRUE/FALSE) status of each node.}

\item{zero.na}{A logical parameter that specifies if NAs generated in the
analysis should be reset to zero.  The default is TRUE.}

\item{balance.override}{Mixed Trophic Impacts analysis builds on flow
analysis and thus assumes the network model is at steady-state (inputs =
outputs).  Setting balance.override = TRUE allows the function to be run on
unbalanced models, though this is unadvised.}
}
\value{
\item{G}{output-oriented direct flow intensity matrix as in enaFlow,
except oriented from row to column.} \item{FP}{input-oriented direct flow
intensity matrix similar to enaFlow; however, the calculation exclude
respiration losses from the throughflow in the denominator to focus on NET
production.  Also, if the receiver compartment is not living, the flux
intensity is set to zero.} \item{Q}{direct net trophic impacts (G-t(FP)).}
\item{M}{Total (direct and indirect) tropic impacts of compartment i on j.}
\item{Relations.Table}{A table indicating the qualitiative pairwise
relationships between the nodes as determined from the net (direct)
and the mixed (integral) perspectives.}
}
\description{
Calculates the Mixed Trophic Impacts of one species on another in the given
ecosystem model following the algorithm of Ulanowicz and Puccia (1990). This
considers both the direct and indirect trophic impacts.
}
\details{
This and other Ulanowicz school functions require that export and
respiration components of output be separately quantified.

This analysis is similar in concept to the ENA Utility analysis.
}
\examples{



data(troModels)
mti <- enaMTI(troModels[[6]])
attributes(mti)

}
\references{
%% ~put references to the literature/web site here ~ Ulanowicz,
R.E. and C.J. Puccia.  1990. Mixed trophic impacts in ecosystems.  Coenoses
5, 7--16.
}
\seealso{
\code{\link{enaFlow},\link{enaUtility}}
}
\author{
Stuart R. Borrett Matthew K. Lau
}
