% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_passage.R
\name{en_passage}
\alias{en_passage}
\title{Compute probability of passage of random walks}
\usage{
en_passage(
  en,
  or,
  dest,
  theta = 4,
  simulate_random_points = FALSE,
  rep = 10,
  plot = TRUE
)
}
\arguments{
\item{en}{an enerscape object obtained with \code{enerscape()}.}

\item{or}{origin point.}

\item{dest}{destination point.}

\item{theta}{the degree from which the path randomly deviates from the
least-cost path.}

\item{simulate_random_points}{if to simulate least-cost path among random
points. default = FALSE.}

\item{rep}{number or random origin and destination points if
\code{simulate_random_points = TRUE}. default = 10.}

\item{plot}{if to plot the output.}
}
\value{
A list with point locations, rasterLayer of net passage of random
  walks, and rasterLayer of cumulative net passage if
  \code{simulate_random_points = TRUE}.
}
\description{
Calculate the net number of passages of random walks between origin and
destination.
}
\details{
If \code{or} and \code{dest} are not specified, the least-cost path
  is specified by setting \code{simulate_random_points = TRUE} and \code{rep}
  equal to the number of random paths to compute.
}
\examples{
library(raster)
data("volcano")
dem <- raster(volcano)
en <- enerscape(dem, 10, unit = "kcal", neigh = 16)
p <- xyFromCell(dem, sample(ncell(dem), 2))
walk <- en_passage(en, or = p[1, ], dest = p[2, ], theta = 4)
}
