% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.enpls.od}
\alias{plot.enpls.od}
\title{Plot enpls.od Object}
\usage{
\method{plot}{enpls.od}(x, criterion = c("quantile", "sd"), prob = 0.05,
  sdtimes = 3L, main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{enpls.od}.}

\item{criterion}{Criterion of being outlier,
could be \code{'quantile'} or \code{'sd'}.}

\item{prob}{the quantile}

\item{sdtimes}{the times of sd}

\item{main}{plot title}

\item{...}{Other graphical parameters to be passed on to \code{plot}.}
}
\description{
This function plots enpls.od object.
}
\details{
This function plots enpls.od object.
}
\examples{
\donttest{
data(alkanes)
x = alkanes$x
y = alkanes$y

set.seed(42)
od = enpls.od(x, y)
plot(od, criterion = 'quantile')
plot(od, criterion = 'sd')}
}
\author{
Nan Xiao <\email{road2stat@gmail.com}>
}
\seealso{
See \code{\link{enpls.od}} for outlier detection with ensemble PLS.
}

