% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.enspls.R
\name{plot.enspls.ad}
\alias{plot.enspls.ad}
\title{Plot enspls.ad object}
\usage{
\method{plot}{enspls.ad}(x, type = c("static", "interactive"), main = NULL,
  ...)
}
\arguments{
\item{x}{An object of class \code{enspls.ad}.}

\item{type}{Plot type. Can be \code{"static"} or \code{"interactive"}.}

\item{main}{Plot title.}

\item{...}{Additional graphical parameters for \code{\link{plot}}.}
}
\description{
Plot enspls.ad object
}
\examples{
data("logd1k")
# remove low variance variables
x = logd1k$x[, -c(17, 52, 59)]
y = logd1k$y

# training set
x.tr = x[1:300, ]
y.tr = y[1:300]

# two test sets
x.te = list("test.1" = x[301:400, ],
            "test.2" = x[401:500, ])
y.te = list("test.1" = y[301:400],
            "test.2" = y[401:500])

set.seed(42)
ad = enspls.ad(x.tr, y.tr, x.te, y.te,
               maxcomp = 3, alpha = c(0.3, 0.6, 0.9),
               space = "variable", method = "mc",
               ratio = 0.8, reptimes = 10)
plot(ad)
# The interactive plot requires a HTML viewer
\dontrun{
plot(ad, type = "interactive")}
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\seealso{
See \code{\link{enspls.ad}} for model applicability domain
evaluation with ensemble sparse partial least squares regressions.
}

