% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemblQueryLDregionEndpoint.R
\name{ensemblQueryLDwithSNPregionDataframe}
\alias{ensemblQueryLDwithSNPregionDataframe}
\title{`ensemblQueryLDwithSNPregionDataframe` applies `ensemblQueryLDwithSNPregion` to a data.frame of genomic coordinates and returns all variant pairs present in each specified genomic region and their associated LD metrics.}
\usage{
ensemblQueryLDwithSNPregionDataframe(
  in.table,
  pop = "1000GENOMES:phase_3:EUR",
  cores = 1
)
}
\arguments{
\item{in.table}{Dataframe containing genomic coordinates. Columns must include `chr` (the chromosome), `start` (the starting genomic coordinate) and `end` (the ending genomic coordinate).}

\item{pop}{String. Population for which to compute LD. Use `ensemblQueryGetPops()` to retrieve a list of all populations with LD data. Default is 1000GENOMES:phase_3:EUR.}

\item{cores}{Integer. A value between 1 and 10 is accepted, as this prevents the server returning overload-related errors.}
}
\value{
A dataframe.
}
\description{
`ensemblQueryLDwithSNPregionDataframe` applies `ensemblQueryLDwithSNPregion` to a data.frame of genomic coordinates and returns all variant pairs present in each specified genomic region and their associated LD metrics.
}
\examples{
\dontrun{
library(magrittr)

data.frame(
  chr=rep(c("6"), 5),
  start=rep(c("25837556"), 5),
  end=rep(c("25943455"), 5)
) \%>\%
  ensemblQueryLDwithSNPregionDataframe(
    in.table=.,
    pop="1000GENOMES:phase_3:EUR",
    cores = 1
  )
}
}
