% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemblQueryLDwindowEndpoint.R
\name{ensemblQueryLDwithSNPwindowDataframe}
\alias{ensemblQueryLDwithSNPwindowDataframe}
\title{`ensemblQueryLDwithSNPwindowDataframe` applies `ensemblQueryLDwithSNPwindow` to a data.frame of rsIDs.}
\usage{
ensemblQueryLDwithSNPwindowDataframe(
  in.table,
  pop = "1000GENOMES:phase_3:EUR",
  r2 = NA,
  d.prime = NA,
  window.size = NA,
  cores = 1
)
}
\arguments{
\item{in.table}{data.frame containing SNP pairs. Columns must include `rsid1` for the first member of the pair and `rsid2` for the second member of the pair.}

\item{pop}{String. Population for which to compute LD. Use `ensemblQueryGetPops()` to retrieve a list of all populations with LD data. Default is 1000GENOMES:phase_3:EUR.}

\item{r2}{Float. Measure of LD. If r-squared is provided only return pairs of variants whose r-squared value is equal to or greater than the value provided.}

\item{d.prime}{Float. Measure of LD. If D' is provided only return pairs of variants whose D' value is equal to or greater than the value provided.}

\item{window.size}{Integer. Window size in kb. The maximum allowed value for the window size is 500 kb. LD is computed for the given variant and all variants that are located within the specified window.}

\item{cores}{Integer. A value between 1 and 10 is accepted, as this prevents the server returning overload-related errors.}
}
\value{
A dataframe.
}
\description{
`ensemblQueryLDwithSNPwindowDataframe` applies `ensemblQueryLDwithSNPwindow` to a data.frame of rsIDs.
}
\examples{
\dontrun{
in.table = data.frame(rsid = rep(c("rs7153434","rs1963154","rs12672022",
                                   "rs3852802","rs12324408","rs56346870"), 5))

ensemblQueryLDwithSNPwindowDataframe(in.table=in.table,
                                     pop="1000GENOMES:phase_3:EUR",
                                     r2=0.8,
                                     d.prime=0.8,
                                     window.size=500,
                                     cores=1)
}
}
