% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{plotmz}
\alias{plotmz}
\title{plot GC/LC-MS data as scatter plot}
\usage{
plotmz(data, inscf = 5, ...)
}
\arguments{
\item{data}{imported data matrix of GC-MS}

\item{inscf}{Log intensity cutoff for peaks, default 5}

\item{...}{parameters for `plot` function}
}
\value{
scatter plot
}
\description{
plot GC/LC-MS data as scatter plot
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file('cdf', package = 'faahKO')
cdffiles <- list.files(cdfpath, recursive = TRUE, full.names = TRUE)
matrix <- getmd(cdffiles[1])
png('test.png')
plotmz(matrix)
dev.off()
}
}
