% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach_source.R
\name{attach_source}
\alias{attach_source}
\title{Source R files in an attached environment}
\usage{
attach_source(
  ...,
  name = as_tidy_env_name(c(...), prefix = "source:"),
  recursive = FALSE,
  pos = 2L,
  chdir = FALSE,
  warn.conflicts = TRUE,
  mask.ok = NULL
)
}
\arguments{
\item{...}{filepaths to R files, or paths to directories containing R files.}

\item{name}{A string, the name for the attached environment. By default, the
name is constructed from paths supplied to \code{...}. If the requested name is
not on the search path, a new environment of this name is attached.}

\item{recursive}{If directories are passed to \code{...}, whether to search them
recursively.}

\item{pos}{The position where to attach the environment, if creating a new
one. If an environment of \code{name} already exists, \code{pos} is ignored.}

\item{chdir}{logical. if TRUE, the \R working directory is temporarily
changed to the directory containing the file(s) being sourced.}

\item{warn.conflicts}{logical. If TRUE (the default), print warnings about
objects in the attached environment that that are masking or masked by
other objects of the same name.}

\item{mask.ok}{character vector of names of objects that can mask objects on
the search path without signaling a warning if \code{warn.conflicts} is \code{TRUE}}
}
\value{
The attached environment, invisibly.
}
\description{
Source R files in an attached environment
}
\note{
One subtlety that is sometimes important: the global environment or any
packages attached after this environment is created will be not on the search
path for the environment where the source is evaluated. The search path of
the environment the R files are sourced in is \code{tail(search(), -pos)}.

This means that, for example, if you source a script that calls
\code{library()}, the code in that script will not "see" the functions from the
newly attached packages. This is by design. However, if you want to source
scripts that call \code{library} and define new functions, and you want those
new functions to "see" the \code{library} attached packages, here are 3 ways to
do that:
\enumerate{
\item Attach all the packages you want before attaching the script:
}\if{html}{\out{<div class="r">}}\preformatted{library(foo); library(bar)
attach_source("my_script.R")
}\if{html}{\out{</div>}}
\enumerate{
\item Modify the default \code{pos} argument to \code{library}, so all new packages
attach after your script:
}\if{html}{\out{<div class="r">}}\preformatted{envir:::set_default_library_pos(after = "source:my_script.R")
attach_source("my_script.R")
}\if{html}{\out{</div>}}
\enumerate{
\item This is the likely the most preferred solution. Instead of sourcing
files directly in the attached environment, source the files into a new
environment that inherits from \code{.Globalenv}, and then copy over everything
to the attached environment.
}\if{html}{\out{<div class="r">}}\preformatted{attach_eval(\{
  import_from("my_script.R")
\})
}\if{html}{\out{</div>}}
}
\seealso{
\link{import_from}, \link{set_library_default_pos}
}
