% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntradayDataAPI.R
\name{get_intraday_historical_data}
\alias{get_intraday_historical_data}
\title{Get historical intraday data}
\usage{
get_intraday_historical_data(
  api_token,
  symbol,
  from_unix_time = NULL,
  to_unix_time = NULL,
  interval = "5m"
)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{symbol}{consists of two parts: SYMBOL_NAME.EXCHANGE_ID, then you can use, for example, AAPL.MX for Mexican Stock Exchange. or AAPL.US for NASDAQ}

\item{from_unix_time}{Parameters should be passed in UNIX time with UTC timezone, for example,
these values are correct: “from=1627896900&to=1630575300” and correspond to
‘ 2021-08-02 09:35:00 ‘ and ‘ 2021-09-02 09:35:00 ‘.}

\item{to_unix_time}{Parameters should be passed in UNIX time with UTC timezone.}

\item{interval}{the possible intervals: ‘5m’ for 5-minutes, ‘1h’ for 1 hour, and ‘1m’ for 1-minute intervals.}
}
\value{
A list containing the historical data.
}
\description{
This function retrieves historical intraday data from the API.
IMPORTANT: data for all exchanges is provided in the UTC timezone, with Unix timestamps.
}
\examples{
api_token <- "demo"
from_unix_time <- "1627896900"
to_unix_time <- "1630575300"
symbol <- "AAPL.MX"
interval <- "5m"
result <- get_intraday_historical_data(api_token, symbol, from_unix_time, to_unix_time, interval)

}
