% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toffice.R
\name{topptx}
\alias{topptx}
\title{export figure to pptx}
\usage{
topptx(figure = NULL, filename = NULL, width = 6, height = 6,
  append = FALSE, devsize = FALSE, units = "in")
}
\arguments{
\item{figure}{plot figure function}

\item{filename}{output filename}

\item{width}{width of the output figure}

\item{height}{height of the output figure}

\item{append}{append or not}

\item{devsize}{Boolean value show use device size or not (default = FALSE)}

\item{units}{the units in which to return the value – inches, cm, or pixels (device units)}
}
\description{
export figure to pptx
}
\examples{
if(interactive()){
plot(mtcars$mpg, mtcars$disp)
topptx(filename = file.path(tempdir(), "mtcars.pptx"))
## use ggplot2
ggplot(mtcars, aes(mpg, disp, color = factor(cyl))) + geom_point()
topptx(filename = file.path(tempdir(), "mtcars.pptx"))
}
}
\author{
Kai Guo
}
